<?php 
	class Assembling {

		public $id;
		public $serialNumber;
		public $product;
		public $description;
		public $size;
		public $fabric;
		public $buttons;
		public $zips;
		public $created_on;
		public $updated_on;

		public $tableName = 'assembling';
		public $dbConn;


		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function addAssembly() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET serialNumber = :serialNumber, product = :product, description = :description, size = :size, fabric = :fabric, buttons = :buttons, zips = :zips';

          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);

          	// Clean data
          	$this->serialNumber = htmlspecialchars(strip_tags($this->serialNumber));
          	$this->product = htmlspecialchars(strip_tags($this->product));
          	$this->description = htmlspecialchars(strip_tags($this->description));
          	$this->size = htmlspecialchars(strip_tags($this->size));
          	$this->fabric = htmlspecialchars(strip_tags($this->fabric));
          	$this->buttons = htmlspecialchars(strip_tags($this->buttons));
          	$this->zips = htmlspecialchars(strip_tags($this->zips));

          	// Bind data
          	$myStatement->bindParam(':serialNumber', $this->serialNumber);
          	$myStatement->bindParam(':product', $this->product);
			$myStatement->bindParam(':description', $this->description);
			$myStatement->bindParam(':size', $this->size);
			$myStatement->bindParam(':fabric', $this->fabric);
			$myStatement->bindParam(':buttons', $this->buttons);
			$myStatement->bindParam(':zips', $this->zips);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}
	}
 ?>