<?php 
	class ManageBranch {

		public $id;
		public $branchCode;
		public $branchName;
		public $branchEmail;
		public $branchPhone;
		public $branchAddress;
		public $branchManager;

		public $tableName = 'tblmanage_branches';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function createBranch() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET branchCode = :branchCode, branchName = :branchName, branchEmail = :branchEmail, branchPhone = :branchPhone, branchAddress = :branchAddress';

          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);

          	// Clean data
          	$this->branchCode = htmlspecialchars(strip_tags($this->branchCode));
          	$this->branchName = htmlspecialchars(strip_tags($this->branchName));
          	$this->branchEmail = htmlspecialchars(strip_tags($this->branchEmail));
          	$this->branchPhone = htmlspecialchars(strip_tags($this->branchPhone));
          	$this->branchAddress = htmlspecialchars(strip_tags($this->branchAddress));
          	// Bind data
          	$myStatement->bindParam(':branchCode', $this->branchCode);
          	$myStatement->bindParam(':branchName', $this->branchName);
			$myStatement->bindParam(':branchEmail', $this->branchEmail);
			$myStatement->bindParam(':branchPhone', $this->branchPhone);
			$myStatement->bindParam(':branchAddress', $this->branchAddress);
			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}
	}
 ?>