<?php 
	class PurchaseOrder {

		public $id;
		public $item;
		public $description;
		public $quantity;
		public $unitPrice;
		public $tax;
		public $amount;
		public $paymentMode;
		public $currency;
		public $vendorSupplier;
		public $invoiceNumber;
		public $paymentDate;

		public $tableName = 'purchaseorders';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function addOrder() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET item = :item, description = :description, quantity = :quantity, unitPrice = :unitPrice, tax = :tax, amount = :amount, paymentMode = :paymentMode, currency = :currency, vendorSupplier = :vendorSupplier, invoiceNumber = :invoiceNumber, paymentDate = :paymentDate';
          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);
          	// Clean data
          	$this->item = htmlspecialchars(strip_tags($this->item));
          	$this->description = htmlspecialchars(strip_tags($this->description));
          	$this->quantity = htmlspecialchars(strip_tags($this->quantity));
          	$this->unitPrice = htmlspecialchars(strip_tags($this->unitPrice));
          	$this->tax = htmlspecialchars(strip_tags($this->tax));
          	$this->amount = htmlspecialchars(strip_tags($this->amount));
          	$this->paymentMode = htmlspecialchars(strip_tags($this->paymentMode));
          	$this->currency = htmlspecialchars(strip_tags($this->currency));
          	$this->vendorSupplier = htmlspecialchars(strip_tags($this->vendorSupplier));
          	$this->invoiceNumber = htmlspecialchars(strip_tags($this->invoiceNumber));
          	$this->paymentDate = htmlspecialchars(strip_tags($this->paymentDate));

          	// Bind data
          	$myStatement->bindParam(':item', $this->item);
          	$myStatement->bindParam(':description', $this->description);
          	$myStatement->bindParam(':quantity', $this->quantity);
          	$myStatement->bindParam(':unitPrice', $this->unitPrice);
          	$myStatement->bindParam(':tax', $this->tax);
          	$myStatement->bindParam(':amount', $this->amount);
          	$myStatement->bindParam(':paymentMode', $this->paymentMode);
          	$myStatement->bindParam(':currency', $this->currency);
          	$myStatement->bindParam(':invoiceNumber', $this->invoiceNumber);
          	$myStatement->bindParam(':vendorSupplier', $this->vendorSupplier);
          	$myStatement->bindParam(':paymentDate', $this->paymentDate);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

	}
 ?>