<?php 
	class Reconciliation {

		public $id;
		public $vendorSuplier;
		public $reconcileDate;
		public $invoiceNumber;
		public $receiptNumber;
		public $amount;
		public $amountPaid;
		public $balance;
		public $reconAmount;

		public $tableName = 'tblcreditors_reconciliation';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function reconcile() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET vendorSuplier = :vendorSuplier, reconcileDate = :reconcileDate, invoiceNumber = :invoiceNumber, receiptNumber = :receiptNumber, amount = :amount, amountPaid = :amountPaid, balance = :balance, reconAmount = :reconAmount';
          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);
          	// Clean data
          	$this->vendorSuplier = htmlspecialchars(strip_tags($this->vendorSuplier));
          	$this->reconcileDate = htmlspecialchars(strip_tags($this->reconcileDate));
          	$this->invoiceNumber = htmlspecialchars(strip_tags($this->invoiceNumber));
          	$this->receiptNumber = htmlspecialchars(strip_tags($this->receiptNumber));
          	$this->amount = htmlspecialchars(strip_tags($this->amount));
          	$this->amountPaid = htmlspecialchars(strip_tags($this->amountPaid));
          	$this->balance = htmlspecialchars(strip_tags($this->balance));
          	$this->reconAmount = htmlspecialchars(strip_tags($this->reconAmount));

          	// Bind data
          	$myStatement->bindParam(':vendorSuplier', $this->vendorSuplier);
          	$myStatement->bindParam(':reconcileDate', $this->reconcileDate);
          	$myStatement->bindParam(':invoiceNumber', $this->invoiceNumber);
          	$myStatement->bindParam(':receiptNumber', $this->receiptNumber);
          	$myStatement->bindParam(':amount', $this->amount);
          	$myStatement->bindParam(':amountPaid', $this->amountPaid);
          	$myStatement->bindParam(':balance', $this->balance);
            $myStatement->bindParam(':reconAmount', $this->reconAmount);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

	}
 ?>