<?php 
	class CashDeposit {

		public $id;
          public $branch;
          public $folioNumber;
		public $station;
		public $totalUsd;
		public $totalRands;
		public $totalZwl;

		public $tableName = 'cashdeposit';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function addNewRecord() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET branch = :branch, folioNumber = :folioNumber, station = :station, totalUsd = :totalUsd, totalRands = :totalRands, totalZwl = :totalZwl';
          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);
          	// Clean data
          	$this->branch = htmlspecialchars(strip_tags($this->branch));
          	$this->folioNumber = htmlspecialchars(strip_tags($this->folioNumber));
          	$this->station = htmlspecialchars(strip_tags($this->station));
          	$this->totalUsd = htmlspecialchars(strip_tags($this->totalUsd));
          	$this->totalRands = htmlspecialchars(strip_tags($this->totalRands));
          	$this->totalZwl = htmlspecialchars(strip_tags($this->totalZwl));

          	// Bind data
          	$myStatement->bindParam(':branch', $this->branch);
          	$myStatement->bindParam(':folioNumber', $this->folioNumber);
          	$myStatement->bindParam(':station', $this->station);
          	$myStatement->bindParam(':totalUsd', $this->totalUsd);
          	$myStatement->bindParam(':totalRands', $this->totalRands);
          	$myStatement->bindParam(':totalZwl', $this->totalZwl);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

	}
 ?>