document.addEventListener('DOMContentLoaded', function() {
    document.querySelector('#generateDispatchedValue').addEventListener('submit', function(e) {
      e.preventDefault();
  
      const startDate = document.querySelector('#dispatchedstartDate').value;
      const endDate = document.querySelector('#dispatchedendDate').value;
  
      const xhr = new XMLHttpRequest();
      xhr.open('POST', 'stores-reports/get-dispatched-value.php', true);
      xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
      xhr.onload = function() {
        if (this.status === 200) {
          document.querySelector('#dispatchedValueResults').innerHTML = this.responseText;
  
let totalValue = 0;
const stockDataRows = document.querySelectorAll('#dispatchedValue tbody tr');
stockDataRows.forEach(function(row) {
  if (row.querySelector('td:nth-child(4)')) {
    const cellValue = parseFloat(row.querySelector('td:nth-child(4)').textContent);
    if (!isNaN(cellValue)) {
      totalValue += cellValue;
    }
  }
});

if(isNaN(totalValue)) {
    document.querySelector('#totalCostValue').value = '';
  } else {
    document.querySelector('#totalDispatchedValue').value = totalValue.toFixed(2);
  }  

if (stockDataRows.length > 0) {
  document.querySelector('#saveDispatchedResportPDFButton').removeAttribute('disabled');
}
        }
      }
      xhr.send('startDate=' + startDate + '&endDate=' + endDate);
    });
  });