<!DOCTYPE html>
<html>
<head>
	<title>Sales Data</title>
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
</head>
<body>
	<form id="sales-form">
		<label for="saleDate">Sale Date:</label>
		<input type="date" id="saleDate" name="saleDate"><br><br>

		<label for="cashierName">Cashier Name:</label>
		<input type="text" id="cashierName" name="cashierName"><br><br>

		<label for="currency">Currency:</label>
		<select id="currency" name="currency">
			<option value="USD">USD</option>
			<option value="EUR">EUR</option>
			<option value="GBP">GBP</option>
		</select><br><br>

		<input type="submit" value="Submit">
	</form>

	<div id="sales-data"></div>

	<script>
		$(document).ready(function() {
			$('#sales-form').submit(function(event) {
				event.preventDefault();

				$.ajax({
					type: 'POST',
					url: 'fetch_sales.php',
					data: $(this).serialize(),
					success: function(response) {
						if (response.error) {
							$('#sales-data').html("<p>" + response.error + "</p>");
						} else {
							var rows = response.rows;
							var totalAmount = response.totalAmount;
                            var html = "<table class='table table-bordered' id='saleItem'>";
          html += "<tr><th scope='col'>#</th><th scope='col'>Product</th>  <th scope='col'>Quantity</th><th scope='col'>Total Price</th></tr>";
          for (var i = 0; i < rows.length; i++) {
            var row = rows[i];
            html += "<tr><td>" + row.itemName + "</td><td>" + row.unit_price + "</td><td>" + row.quantity + "</td><td>" + row.amount + "</td></tr>";
          }
							html += "<tr><td>Total Amount:</td><td>" + totalAmount + "</td></tr>";
							html += "</table>";
							$('#sales-data').html(html);
						}
					},
					error: function() {
						$('#sales-data').html("<p>Failed to retrieve sales data.</p>");
					}
				});
			});
		});
	</script>
</body>
</html>
