<?php 
	class Order {

		public $id;
		public $item;
		public $description;
		public $quantity;
		public $amount;
		public $customerName;
		public $quoteNumber;
		public $orderStatus;
		public $orderId;

		public $tableName = 'orders';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function addOrder() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET item = :item, description = :description, quantity = :quantity, amount = :amount, customerName = :customerName, quoteNumber = :quoteNumber, orderStatus = :orderStatus, orderId = :orderId';
          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);
          	// Clean data
          	$this->item = htmlspecialchars(strip_tags($this->item));
          	$this->description = htmlspecialchars(strip_tags($this->description));
          	$this->quantity = htmlspecialchars(strip_tags($this->quantity));
          	$this->amount = htmlspecialchars(strip_tags($this->amount));
          	$this->customerName = htmlspecialchars(strip_tags($this->customerName));
          	$this->quoteNumber = htmlspecialchars(strip_tags($this->quoteNumber));
          	$this->orderStatus = htmlspecialchars(strip_tags($this->orderStatus));
          	$this->orderId = htmlspecialchars(strip_tags($this->orderId));

          	// Bind data
          	$myStatement->bindParam(':item', $this->item);
			$myStatement->bindParam(':description', $this->description);
			$myStatement->bindParam(':quantity', $this->quantity);
			$myStatement->bindParam(':amount', $this->amount);
			$myStatement->bindParam(':customerName', $this->customerName);
			$myStatement->bindParam(':quoteNumber', $this->quoteNumber);
			$myStatement->bindParam(':orderStatus', $this->orderStatus);
			$myStatement->bindParam(':orderId', $this->orderId);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

	}
 ?>