<?php 
	class PaymentSalaries {

		public $id;
        public $employeeName;
        public $accountNumber;
        public $branchName;
        public $month;
		public $salaryAmount;
		public $extraTime;
		public $currencySymbol;
		public $paymentMode;
		public $chartOfAccounts;
        public $branch;
		public $salaryDate;

		public $tableName = 'paymentsalaries';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function addSalaryRecord() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET accountNumber = :accountNumber, branchName = :branchName, employeeName = :employeeName, month = :month, salaryAmount = :salaryAmount, extraTime = :extraTime, currencySymbol = :currencySymbol, paymentMode = :paymentMode, chartOfAccounts =:chartOfAccounts, branch = :branch, salaryDate = :salaryDate';
          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);
          	// Clean data
          	$this->accountNumber = htmlspecialchars(strip_tags($this->accountNumber));
          	$this->branchName = htmlspecialchars(strip_tags($this->branchName));
          	$this->employeeName = htmlspecialchars(strip_tags($this->employeeName));
          	$this->month = htmlspecialchars(strip_tags($this->month));
          	$this->salaryAmount = htmlspecialchars(strip_tags($this->salaryAmount));
          	$this->extraTime = htmlspecialchars(strip_tags($this->extraTime));
          	$this->currencySymbol = htmlspecialchars(strip_tags($this->currencySymbol));
          	$this->paymentMode = htmlspecialchars(strip_tags($this->paymentMode));
          	$this->chartOfAccounts = htmlspecialchars(strip_tags($this->chartOfAccounts));
          	$this->branch = htmlspecialchars(strip_tags($this->branch));
          	$this->salaryDate = htmlspecialchars(strip_tags($this->salaryDate));

          	// Bind data
          	$myStatement->bindParam(':accountNumber', $this->accountNumber);
          	$myStatement->bindParam(':branchName', $this->branchName);
          	$myStatement->bindParam(':employeeName', $this->employeeName);
          	$myStatement->bindParam(':month', $this->month);
          	$myStatement->bindParam(':salaryAmount', $this->salaryAmount);
          	$myStatement->bindParam(':extraTime', $this->extraTime);
          	$myStatement->bindParam(':currencySymbol', $this->currencySymbol);
          	$myStatement->bindParam(':paymentMode', $this->paymentMode);
          	$myStatement->bindParam(':chartOfAccounts', $this->chartOfAccounts);
          	$myStatement->bindParam(':branch', $this->branch);
          	$myStatement->bindParam(':salaryDate', $this->salaryDate);

			if($myStatement->execute()) {
				$accountNumber = $this->accountNumber;
				$this->updateAccountBalance($accountNumber, $this->salaryAmount);
				return true;
			} else {
				return false;
			}
		}
		private function updateAccountBalance($accountNumber, $salaryAmount) {
			$query = 'UPDATE openaccounts SET openingBalance = openingBalance - :salaryAmount WHERE accountNumber = :accountNumber';
	
			$stmt = $this->dbConn->prepare($query);
			$stmt->bindParam(':salaryAmount', $salaryAmount);
			$stmt->bindParam(':accountNumber', $accountNumber);
			$stmt->execute();
		}

	}
 ?>