<?php 
	class PurchaseOrder {

		public $id;
		public $accountType;
		public $item;
		public $description;
		public $quantity;
		public $unitPrice;
		public $tax;
		public $amount;
		public $paymentMode;
		public $currencySymbol;
		public $vendorSupplier;
		public $invoiceNumber;
        public $paymentStatus;
		public $paymentDate;

		public $tableName = 'purchaseorders';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function addOrder() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET accountType = :accountType, item = :item, description = :description, quantity = :quantity, unitPrice = :unitPrice, tax = :tax, amount = :amount, paymentMode = :paymentMode, currencySymbol = :currencySymbol, vendorSupplier = :vendorSupplier, invoiceNumber = :invoiceNumber, paymentStatus = :paymentStatus, paymentDate = :paymentDate';
          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);
          	// Clean data
          	$this->accountType = htmlspecialchars(strip_tags($this->accountType));
			$this->item = htmlspecialchars(strip_tags($this->item));
          	$this->description = htmlspecialchars(strip_tags($this->description));
          	$this->quantity = htmlspecialchars(strip_tags($this->quantity));
          	$this->unitPrice = htmlspecialchars(strip_tags($this->unitPrice));
          	$this->tax = htmlspecialchars(strip_tags($this->tax));
          	$this->amount = htmlspecialchars(strip_tags($this->amount));
          	$this->paymentMode = htmlspecialchars(strip_tags($this->paymentMode));
          	$this->currencySymbol = htmlspecialchars(strip_tags($this->currencySymbol));
          	$this->vendorSupplier = htmlspecialchars(strip_tags($this->vendorSupplier));
          	$this->invoiceNumber = htmlspecialchars(strip_tags($this->invoiceNumber));
            $this->paymentStatus = htmlspecialchars(strip_tags($this->paymentStatus));
          	$this->paymentDate = htmlspecialchars(strip_tags($this->paymentDate));

          	// Bind data
          	$myStatement->bindParam(':accountType', $this->accountType);
			$myStatement->bindParam(':item', $this->item);
          	$myStatement->bindParam(':description', $this->description);
          	$myStatement->bindParam(':quantity', $this->quantity);
          	$myStatement->bindParam(':unitPrice', $this->unitPrice);
          	$myStatement->bindParam(':tax', $this->tax);
          	$myStatement->bindParam(':amount', $this->amount);
          	$myStatement->bindParam(':paymentMode', $this->paymentMode);
          	$myStatement->bindParam(':currencySymbol', $this->currencySymbol);
          	$myStatement->bindParam(':invoiceNumber', $this->invoiceNumber);
          	$myStatement->bindParam(':vendorSupplier', $this->vendorSupplier);
            $myStatement->bindParam(':paymentStatus', $this->paymentStatus);
          	$myStatement->bindParam(':paymentDate', $this->paymentDate);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

	}
 ?>