<?php 
class PaymentsBills {
    public $id;
    public $paymentMode;
    public $currencySymbol;
    public $billType;
    public $branchName;
    public $accountName;
    public $chartOfAccounts;
    public $accountNumber;
    public $amount;
    public $memo;
    public $paymentDate;

    public $tableName = 'paymentbills';
    public $dbConn;

    public function __construct($db) {
        $this->dbConn = $db;
    }
    
    public function addBill() {
        $query = 'INSERT INTO ' . $this->tableName . ' SET paymentMode = :paymentMode, currencySymbol = :currencySymbol, billType = :billType, branchName = :branchName, chartOfAccounts = :chartOfAccounts, accountName = :accountName, accountNumber = :accountNumber, amount = :amount, memo = :memo, paymentDate = :paymentDate';
        // Prepare statement
        $myStatement = $this->dbConn->prepare($query);
        // Clean data
        $this->paymentMode = htmlspecialchars(strip_tags($this->paymentMode));
        $this->currencySymbol = htmlspecialchars(strip_tags($this->currencySymbol));
        $this->billType = htmlspecialchars(strip_tags($this->billType));
        $this->branchName = htmlspecialchars(strip_tags($this->branchName));
        $this->accountName = htmlspecialchars(strip_tags($this->accountName));
        $this->chartOfAccounts = htmlspecialchars(strip_tags($this->chartOfAccounts));
        $this->accountNumber = htmlspecialchars(strip_tags($this->accountNumber));
        $this->amount = htmlspecialchars(strip_tags($this->amount));
        $this->memo = htmlspecialchars(strip_tags($this->memo));
        $this->paymentDate = htmlspecialchars(strip_tags($this->paymentDate));

        // Bind data
        $myStatement->bindParam(':paymentMode', $this->paymentMode);
        $myStatement->bindParam(':currencySymbol', $this->currencySymbol);
        $myStatement->bindParam(':billType', $this->billType);
        $myStatement->bindParam(':branchName', $this->branchName);
        $myStatement->bindParam(':accountName', $this->accountName);
        $myStatement->bindParam(':chartOfAccounts', $this->chartOfAccounts);
        $myStatement->bindParam(':accountNumber', $this->accountNumber);
        $myStatement->bindParam(':amount', $this->amount);
        $myStatement->bindParam(':memo', $this->memo);
        $myStatement->bindParam(':paymentDate', $this->paymentDate);

        if ($this->checkSufficientBalance($this->accountNumber, $this->amount)) {
            if ($myStatement->execute()) {
                $accountNumber = $this->accountNumber;
                $this->updateAccountBalance($accountNumber, $this->amount);
                return true;
            } else {
                return false;
            }
        } else {
            // Insufficient balance, display an alert message
            echo "<script>alert('You have Insufficient balance to process this payment!');</script>";
            return false;
        }
    }

    private function checkSufficientBalance($accountNumber, $amount) {
        $query = 'SELECT openingBalance FROM openaccounts WHERE accountNumber = :accountNumber';
        $stmt = $this->dbConn->prepare($query);
        $stmt->bindParam(':accountNumber', $accountNumber);
        $stmt->execute();

        if ($stmt->rowCount() > 0) {
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            $openingBalance = $row['openingBalance'];

            if ($openingBalance >= $amount) {
                return true;
            }
        }

        return false;
    }

    private function updateAccountBalance($accountNumber, $amount) {
        $query = 'UPDATE openaccounts SET openingBalance = openingBalance - :amount WHERE accountNumber = :accountNumber';

        $stmt = $this->dbConn->prepare($query);
        $stmt->bindParam(':amount', $amount);
        $stmt->bindParam(':accountNumber', $accountNumber);
        $stmt->execute();
    }
}
?>