function addRow() {
  var table = document.getElementById("requisitionItem");
  var newRow = document.createElement("tr");
  newRow.innerHTML = `
    <td><input type="checkbox" class="itemRow custom-control-input" name="delete[]" id="itemRow_1"> <label class="custom-control-label" for="itemRow_1"></label></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="form-control" name="itemName[]" placeholder="item name" id="itemName"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="form-control" name="description[]" placeholder="description" id="description"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="number" class="quantity form-control" name="quantity[]" id="quantity" placeholder="Quantity"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="unit_price form-control" name="unit_price[]" id="unit_price" placeholder="unit price"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="number" class="itemCost form-control" name="itemCost[]" id="itemCost" placeholder="item cost"></div></div></div></td>
  `;
  table.querySelector("tbody").appendChild(newRow);

  // attach event listeners to the new quantity and itemCost fields
  const itemCost = newRow.querySelector('.itemCost');
  itemCost.addEventListener('change', calculateTotalCost);

  const unit_price = newRow.querySelector('.unit_price');
  unit_price.addEventListener('change', calculateTotalCost);

  const quantity = newRow.querySelector('.quantity');
  quantity.addEventListener('change', calculateTotalCost);
}

function deleteRow() {
  var table = document.getElementById("requisitionItem");
  var checkboxes = table.querySelectorAll('input[type="checkbox"][name="delete[]"]');
  for (var i = checkboxes.length - 1; i >= 0; i--) {
    if (checkboxes[i].checked) {
      table.deleteRow(i + 1);
    }
  }
  calculateTotalCost();
}

function calculateTotalCost() {
  var table = document.getElementById("requisitionItem");
  var rows = table.querySelectorAll("tbody tr");
  var totalCost = 0;
  
  rows.forEach(function (row) {
    var quantityInput = row.querySelector(".quantity");
    var unitPriceInput = row.querySelector(".unit_price");
    var itemCostInput = row.querySelector(".itemCost");
    
    var quantity = parseFloat(quantityInput.value);
    var unitPrice = parseFloat(unitPriceInput.value);
    
    if (!isNaN(quantity) && !isNaN(unitPrice)) {
      var itemCost = quantity * unitPrice;
      itemCostInput.value = itemCost.toFixed(2);
      totalCost += itemCost;
    } else {
      itemCostInput.value = "";
    }
  });
  
  document.getElementById("totalCost").value = totalCost.toFixed(2);
}