<?php
include("../includes/DbConnect.php");
$startDate = $_POST['startDate'];
$endDate = $_POST['endDate'];

// Retrieve purchase orders and calculate total by item and currencySymbol
$purchaseOrdersQuery = $dbConn->prepare("SELECT item, SUM(amount) as total, currencySymbol FROM purchaseorders GROUP BY item, currencySymbol");
$purchaseOrdersQuery->execute();
$result1 = $purchaseOrdersQuery->fetchAll();

// Retrieve bills within the specified date range
$billsQuery = $dbConn->prepare("SELECT billType, amount, currencySymbol FROM paymentbills WHERE paymentDate BETWEEN :startDate AND :endDate");
$billsQuery->execute(['startDate' => $startDate, 'endDate' => $endDate]);
$result2 = $billsQuery->fetchAll();

// Retrieve salaries within the specified date range
$salariesQuery = $dbConn->prepare("SELECT employeeName, salaryAmount, currencySymbol FROM paymentsalaries WHERE salaryDate BETWEEN :startDate AND :endDate");
$salariesQuery->execute(['startDate' => $startDate, 'endDate' => $endDate]);
$result3 = $salariesQuery->fetchAll();

// Calculate total for purchases by currencySymbol
$totalPurchases = array();
foreach ($result1 as $row) {
    $currencySymbol = $row['currencySymbol'];
    if (!isset($totalPurchases[$currencySymbol])) {
        $totalPurchases[$currencySymbol] = 0;
    }
    $totalPurchases[$currencySymbol] += $row['total'];
}

// Calculate total for bills by currencySymbol
$totalBills = array();
foreach ($result2 as $row) {
    $currencySymbol = $row['currencySymbol'];
    if (!isset($totalBills[$currencySymbol])) {
        $totalBills[$currencySymbol] = 0;
    }
    $totalBills[$currencySymbol] += $row['amount'];
}

// Calculate total for salaries by currencySymbol
$totalSalaries = array();
foreach ($result3 as $row) {
    $currencySymbol = $row['currencySymbol'];
    if (!isset($totalSalaries[$currencySymbol])) {
        $totalSalaries[$currencySymbol] = 0;
    }
    $totalSalaries[$currencySymbol] += $row['salaryAmount'];
}

// Generate the report
echo "<table>";
echo "<tr><th>PURCHASES</th><th></th></tr>";
foreach ($result1 as $row) {
    echo "<tr><td>" . $row['item'] . "</td>";
    echo "<td>" . number_format($row['total'], 4) . " <b>(" . $row['currencySymbol'] . ")</b></td></tr>";
}
echo "<tr><td colspan='2'><b>Total Purchases:</b></td></tr>";
foreach ($totalPurchases as $currencySymbol => $total) {
    echo "<tr><td><b>(" . $currencySymbol . ")</b></td>";
    echo "<td>" . number_format($total, 4) . "</td></tr>";
}

echo "<tr><th>BILLS</th><th></th></tr>";
foreach ($result2 as $row) {
    echo "<tr><td>" . $row['billType'] . "</td>";
    echo "<td>" . number_format($row['amount'], 4) . " <b>(" . $row['currencySymbol'] . ")</b></td></tr>";
}
echo "<tr><td colspan='2'><b>Total Bills:</b></td></tr>";
foreach ($totalBills as $currencySymbol => $total) {
    echo "<tr><td><b>(" . $currencySymbol . ")</b></td>";
    echo "<td>" . number_format($total, 4) . "</td></tr>";
}

echo "<tr><th>SALARIES</th><th></th></tr>";
foreach ($result3 as $row) {
    echo "<tr><td>" . $row['employeeName'] . "</td>";
    echo "<td>" . number_format($row['salaryAmount'], 4) . " <b>(" . $row['currencySymbol'] . ")</b></td></tr>";
}
echo "<tr><td colspan='2'><b>Total Salaries:</b></td></tr>";
foreach ($totalSalaries as $currencySymbol => $total) {
    echo "<tr><td><b>(" . $currencySymbol . ")</b></td>";
    echo "<td>" . number_format($total, 4) . "</td></tr>";
}

echo "</table>";
?>