document.addEventListener('DOMContentLoaded', function () {
  const quantityInput = document.getElementById('quantity');
  const unitPriceInput = document.getElementById('unitPrice');
  const taxInput = document.getElementById('tax');
  const amountInput = document.getElementById('amount');

  quantityInput.addEventListener('input', calculateAmount);
  unitPriceInput.addEventListener('input', calculateAmount);
  taxInput.addEventListener('input', calculateAmount);

  function calculateAmount() {
    const quantity = parseFloat(quantityInput.value.replace(/,/g, '')) || 0;
    const unitPrice = parseFloat(unitPriceInput.value.replace(/,/g, '')) || 0;
    const tax = parseFloat(taxInput.value.replace(/,/g, '')) || 0;

    const amount = (quantity * unitPrice) + ((quantity * unitPrice * tax) / 100);

    amountInput.value = amount.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
  }
});