function addRow() {
  var table = document.getElementById("invoiceItem");
  var newRow = document.createElement("tr");
  newRow.innerHTML = `
    <td><input type="checkbox" class="itemRow custom-control-input" name="delete[]" id="itemRow_1"> <label class="custom-control-label" for="itemRow_1"></label></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="form-control" name="itemName[]" placeholder="item name" id="itemName"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="form-control" name="description[]" placeholder="description" id="description"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="unit_price form-control" name="unit_price[]" placeholder="Price" id="unit_price"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="number" class="quantity form-control" name="quantity[]" id="quantity" placeholder="Quantity"></div></div></div></td>
  <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="amount form-control" name="amount[]" id="amount" readonly=""></div></div></div></td>
  `;
  table.querySelector("tbody").appendChild(newRow);
}

function updateItem(unit_price, quantity, amount) {
  if (!unit_price || !quantity || !amount) {
    return;
  }
  var priceValue = parseFloat(unit_price.value) || 0;
  var quantityValue = parseFloat(quantity.value) || 0;
  amount.value = new Intl.NumberFormat('en-US').format(priceValue * quantityValue);

  var table = document.getElementById("invoiceItem");
  var allTotals = table.querySelectorAll(".amount");
  var grandTotal = 0;

  for (var i = 0; i < allTotals.length; i++) {
    var currentTotal = parseFloat(allTotals[i].value);
    if (!isNaN(currentTotal)) {
      grandTotal += currentTotal;
    }
  }
  var grandTotalField = document.getElementById("grandTotal");
  grandTotalField.value = grandTotal;
}

document.addEventListener("input", function (event) {
  var row = event.target.closest("tr");
  if (row) {
    var price = row.querySelector(".unit_price");
    var quantity = row.querySelector(".quantity");
    var amount = row.querySelector(".amount");
    updateItem(price, quantity, amount);
  }
});

function deleteInvoiceRows() {
  var table = document.getElementById("invoiceItem");
  var checkboxes = table.querySelectorAll('input[type="checkbox"][name="delete[]"]');
  for (var i = checkboxes.length - 1; i >= 0; i--) {
    if (checkboxes[i].checked) {
      table.deleteRow(i + 1);
    }
  }
  var allTotals = table.querySelectorAll(".amount");
  var grandTotal = 0;

  for (var i = 0; i < allTotals.length; i++) {
    var currentTotal = parseFloat(allTotals[i].value);
    if (!isNaN(currentTotal)) {
      grandTotal += currentTotal;
    }
  }

  var grandTotalField = document.getElementById("grandTotal");
  grandTotalField.value = grandTotal;
}

document.addEventListener('DOMContentLoaded', () => {
  const grandTotalInput = document.querySelector('input[name="grandTotal"]');
  const taxInput = document.querySelector('input[name="tax"]');
  const totalInput = document.querySelector('input[name="total"]');
  const discountInput = document.querySelector('input[name="discount"]');

  function calculateTotal() {
    const grandTotal = parseFloat(grandTotalInput.value);
    const taxRate = parseFloat(taxInput.value) / 100;
    const discountAmount = parseFloat(discountInput.value) || 0;

    if (isNaN(grandTotal) || isNaN(taxRate)) {
      return;
    }

    const discountedTotal = grandTotal - discountAmount;
    const taxAmount = discountedTotal * taxRate;
    const totalAmount = discountedTotal + taxAmount;

    totalInput.value = new Intl.NumberFormat('en-US', {minimumFractionDigits: 2}).format(totalAmount);
  }

  grandTotalInput.addEventListener("input", calculateTotal);
  taxInput.addEventListener("input", calculateTotal);
  discountInput.addEventListener("input", calculateTotal);
  totalInput.addEventListener("input", calculateTotal);
});

function convertCurrency() {
  const currencySymbol = document.getElementById("currencySymbol").value;
  const amountFields = document.querySelectorAll(".amount");
  const unit_price_fields = document.querySelectorAll(".unit_price");
  const quantity_fields = document.querySelectorAll(".quantity");

  fetch(`../my_api/point-of-sale/currency-conveter-api.php?currencySymbol=${currencySymbol}&amount=1`)
    .then(res => res.json())
    .then(data => {
      const rate = data.rates[currencySymbol];
      
      Array.prototype.forEach.call(amountFields, function (amountField, index) {
        const amount = amountField.value;
        const unit_price = unit_price_fields[index];
        const quantity = quantity_fields[index];
        
        const converted_total_amount = new Intl.NumberFormat('en-US', {minimumFractionDigits: 2}).format((rate * amount.replace(/,/g, '')).toFixed(2));
        const converted_price = new Intl.NumberFormat('en-US', {minimumFractionDigits: 2}).format((rate * unit_price.value.replace(/,/g, '')).toFixed(2));
        const convertedAmount = new Intl.NumberFormat('en-US', {minimumFractionDigits: 2}).format((converted_price * quantityVal).toFixed(2));

        amountField.value = "";
        setTimeout(() => {
          amountField.value = converted_total_amount.toLocaleString('en-US', {minimumFractionDigits: 2});
        }, 0);

        unit_price.value = converted_price.toLocaleString('en-US', {minimumFractionDigits: 2});

      });

      var table = document.getElementById("invoiceItem");
      var allTotalsConverted = table.querySelectorAll(".amount");
      var convertedGrandTotal = 0;

      for (var i = 0; i < allTotalsConverted.length; i++) {
        var currentTotal = parseFloat(allTotalsConverted[i].value.replace(/,/g, ''));
        if (!isNaN(currentTotal)) {
          var price = table.querySelectorAll(".unit_price")[i].value.replace(/,/g, '');
          var quantityVal = table.querySelectorAll(".quantity")[i].value.replace(/,/g, '');
          var convertedPrice = (rate * price).toFixed(2);
          var convertedAmount = (convertedPrice * quantityVal).toFixed(2);

          allTotalsConverted[i].value = "";
          setTimeout(() => {
            allTotalsConverted[i].value = convertedAmount.toLocaleString('en-US', {minimumFractionDigits: 2});
          }, 0);

          convertedGrandTotal += parseFloat(convertedAmount.replace(/,/g, ''));
        }
      }

      document.getElementById("grandTotal").value = convertedGrandTotal.toLocaleString('en-US', {minimumFractionDigits: 3});
    });

  const grandTotalField = document.getElementById("grandTotal");
  const currentGrandTotal = grandTotalField.value;
  fetch(`../my_api/point-of-sale/currency-conveter-api.php?currencySymbol=${currencySymbol}&amount=${currentGrandTotal}`)
    .then(res => res.json())
    .then(data => {
      const rate = data.rates[currencySymbol];
      const convertedGrandTotal = (currentGrandTotal * rate).toFixed(2);
      grandTotalField.value = convertedGrandTotal.toLocaleString('en-US', {minimumFractionDigits: 2});
    });
}

