$(document).ready(function(){
  
  // define createTable() function outside the AJAX request
  function createTable(data) {
  
    var tableHtml = '';
  
    // check if data is defined and not an empty array
    if (data && data.length > 0) { 
      // create a new row for each item in the data array
      for (var i = 0; i < data.length; i++) {
        var checkboxId = "checkbox_" + i;
        tableHtml += '<tr class="item-row">';
        tableHtml += '<td><input type="checkbox" class="itemRow custom-control-input" name="delete[]" id="' + checkboxId + '">';
        tableHtml += '<label class="custom-control-label" for="' + checkboxId + '"></label></td>';
        tableHtml += '<td><input type="text" class="form-control" name="itemName[]" placeholder="item name" value="' + data[i].itemName + '" readonly/></td>';
        tableHtml += '<td><input type="text" class="form-control" name="quantity[]" placeholder="Quantity" required value="' + data[i].quantity + '" readonly/></td>';
        tableHtml += '<td><input type="text" class="amount form-control" name="amount[]" readonly value="' + data[i].amount + '" readonly/></td>';
        tableHtml += '</tr>';

        const saveToPDFButton = document.getElementById('saveToPDFButton');

        saveToPDFButton.disabled = false;
      }
    } else {
      // handle case when data is not defined or empty
      alert('No results found....!.');

      const saveToPDFButton = document.getElementById('saveToPDFButton');
      saveToPDFButton.disabled = true;
      
    }
  
    return tableHtml;
  }
  

  $('#generateReport').submit(function(e){
    e.preventDefault();
    
    var formData = new FormData($(this)[0]);
    
    $.ajax({
      url: 'reports/fetch_sales.php',
      type: 'POST',
      data: formData,
      dataType: 'json', // Set the response datatype to JSON
      success: function (jsonData) {
        console.log('JSON Data:', jsonData);
      
        $('#totalAmount').val(jsonData.totalAmount);
      
        // call createTable() with jsonData.results
        var tableHtml = createTable(jsonData.results);
      
        $('#tableContainer').html(tableHtml);
      
        //$('#addSale').prop('disabled', false);
        
      },      
      error: function(_xhr, _status, error) {
        console.log("Error: " + error);
      },
      cache: false,
      contentType: false,
      processData: false
    });
  });
});