<?php
include("../includes/DbConnect.php");
$startDate = $_POST['startDate'];
$endDate = $_POST['endDate'];

// Retrieve Cash Deposit and calculate total by item and currencySymbol
$creditorsReconQuery = $dbConn->prepare("SELECT * FROM tblcreditors_reconciliation WHERE reconcileDate BETWEEN :startDate AND :endDate GROUP BY id");
$creditorsReconQuery->execute(array(':startDate' => $startDate, ':endDate' => $endDate));
$result1 = $creditorsReconQuery->fetchAll(PDO::FETCH_ASSOC);

// Initialize total variables
$totalAmount = 0;
$totalAmountPaid = 0;
$totalBalance = 0;
$totalReconAmount = 0;
?>

<table>
    <tr>
        <th>Vendor/Supplier</th>
        <th>Invoice Number</th>
        <th>Receipt Number</th>
        <th>Amount</th>
        <th>Amount Paid</th>
        <th>Balance</th>
        <th>Reconciled Amount</th>
    </tr>

    <?php foreach ($result1 as $row) : ?>
        <tr>
            <td><?php echo $row['vendorSuplier']; ?></td>
            <td><?php echo $row['invoiceNumber']; ?></td>
            <td><?php echo $row['receiptNumber']; ?></td>
            <td><?php echo $row['amount']; ?></td>
            <td><?php echo $row['amountPaid']; ?></td>
            <td><?php echo $row['balance']; ?></td>
            <td><?php echo $row['reconAmount']; ?></td>
        </tr>

        <?php
        // Calculate the totals
        $totalAmount += $row['amount'];
        $totalAmountPaid += $row['amountPaid'];
        $totalBalance += $row['balance'];
        $totalReconAmount += $row['reconAmount'];
        ?>

    <?php endforeach; ?>
    
    <tr>
        <th colspan="">TOTALS</th>
        <th></th>
        <th></th>
        <th><?php echo $totalAmount; ?></th>
        <th><?php echo $totalAmountPaid; ?></th>
        <th><?php echo $totalBalance; ?></th>
        <th><?php echo $totalReconAmount; ?></th>
    </tr>

</table>
