<?php 
	class BankAccounts {

		public $id;
        public $branchName;
        public $accountName;
        public $accountNumber;
		public $currencySymbol;
		public $openingBalance;
		public $chartOfAccounts;
		public $accountStatus;

		public $tableName = 'openaccounts';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function addNewRecord() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET accountName = :accountName, accountNumber = :accountNumber, currencySymbol = :currencySymbol, openingBalance = :openingBalance, chartOfAccounts = :chartOfAccounts, accountStatus = :accountStatus, branchName = :branchName';
          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);
          	// Clean data
          	$this->accountName = htmlspecialchars(strip_tags($this->accountName));
          	$this->accountNumber = htmlspecialchars(strip_tags($this->accountNumber));
          	$this->currencySymbol = htmlspecialchars(strip_tags($this->currencySymbol));
          	$this->openingBalance = htmlspecialchars(strip_tags($this->openingBalance));
          	$this->chartOfAccounts = htmlspecialchars(strip_tags($this->chartOfAccounts));
          	$this->accountStatus = htmlspecialchars(strip_tags($this->accountStatus));
          	$this->branchName = htmlspecialchars(strip_tags($this->branchName));

          	// Bind data
          	$myStatement->bindParam(':accountName', $this->accountName);
          	$myStatement->bindParam(':accountNumber', $this->accountNumber);
          	$myStatement->bindParam(':currencySymbol', $this->currencySymbol);
          	$myStatement->bindParam(':openingBalance', $this->openingBalance);
          	$myStatement->bindParam(':chartOfAccounts', $this->chartOfAccounts);
          	$myStatement->bindParam(':accountStatus', $this->accountStatus);
          	$myStatement->bindParam(':branchName', $this->branchName);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

	}
 ?>