<?php 
	class Customers {

		public $id;
		public $customerName;
		public $customerEmail;
		public $customerPhone;
		public $customerAddress;
		public $shippingName;
		public $shippingEmail;
		public $shippingPhone;
		public $shippingAddress;
		public $status;

		public $tableName = 'tblcustomers';
		public $dbConn;


		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function addCustomer() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET customerName = :customerName, customerEmail = :customerEmail, customerPhone = :customerPhone, customerAddress = :customerAddress, shippingName = :shippingName, shippingEmail = :shippingEmail, shippingPhone = :shippingPhone, shippingAddress = :shippingAddress, status = :status';

          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);

          	// Clean data
          	$this->customerName = htmlspecialchars(strip_tags($this->customerName));
          	$this->customerEmail = htmlspecialchars(strip_tags($this->customerEmail));
          	$this->customerPhone = htmlspecialchars(strip_tags($this->customerPhone));
          	$this->customerAddress = htmlspecialchars(strip_tags($this->customerAddress));
          	$this->shippingName = htmlspecialchars(strip_tags($this->shippingName));
          	$this->shippingEmail = htmlspecialchars(strip_tags($this->shippingEmail));
          	$this->shippingPhone = htmlspecialchars(strip_tags($this->shippingPhone));
          	$this->shippingAddress = htmlspecialchars(strip_tags($this->shippingAddress));
          	$this->status = htmlspecialchars(strip_tags($this->status));

          	// Bind data
          	$myStatement->bindParam(':customerName', $this->customerName);
          	$myStatement->bindParam(':customerEmail', $this->customerEmail);
			$myStatement->bindParam(':customerPhone', $this->customerPhone);
			$myStatement->bindParam(':customerAddress', $this->customerAddress);
			$myStatement->bindParam(':shippingName', $this->shippingName);
			$myStatement->bindParam(':shippingEmail', $this->shippingEmail);
			$myStatement->bindParam(':shippingPhone', $this->shippingPhone);
			$myStatement->bindParam(':shippingAddress', $this->shippingAddress);
			$myStatement->bindParam(':status', $this->status);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}
	}
 ?>