<?php 
	class BankAccounts {

		public $id;
        public $accountName;
        public $accountNumber;
		public $currency;
		public $openingBalance;
		public $chartOfAccounts;
		public $accountStatus;

		public $tableName = 'openaccounts';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function addNewRecord() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET accountName = :accountName, accountNumber = :accountNumber, currency = :currency, openingBalance = :openingBalance, chartOfAccounts = :chartOfAccounts, accountStatus = :accountStatus';
          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);
          	// Clean data
          	$this->accountName = htmlspecialchars(strip_tags($this->accountName));
          	$this->accountNumber = htmlspecialchars(strip_tags($this->accountNumber));
          	$this->currency = htmlspecialchars(strip_tags($this->currency));
          	$this->openingBalance = htmlspecialchars(strip_tags($this->openingBalance));
          	$this->chartOfAccounts = htmlspecialchars(strip_tags($this->chartOfAccounts));
          	$this->accountStatus = htmlspecialchars(strip_tags($this->accountStatus));

          	// Bind data
          	$myStatement->bindParam(':accountName', $this->accountName);
          	$myStatement->bindParam(':accountNumber', $this->accountNumber);
          	$myStatement->bindParam(':currency', $this->currency);
          	$myStatement->bindParam(':openingBalance', $this->openingBalance);
          	$myStatement->bindParam(':chartOfAccounts', $this->chartOfAccounts);
          	$myStatement->bindParam(':accountStatus', $this->accountStatus);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

	}
 ?>