document.addEventListener('DOMContentLoaded', function() {
    document.querySelector('#generateStockAtCost').addEventListener('submit', function(e) {
      e.preventDefault(); // Prevent default form submission
  
      // Get input values
      const startDate = document.querySelector('#stockstartDate').value;
      const endDate = document.querySelector('#stockendDate').value;
  
      // Send AJAX request to PHP script
      const xhr = new XMLHttpRequest();
      xhr.open('POST', 'stores-reports/get-stock-at-cost.php', true);
      xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
      xhr.onload = function() {
        if (this.status === 200) {
          // Display stock value report and calculate total value
          document.querySelector('#stockAtCostResults').innerHTML = this.responseText;
  
          // Calculate total value and display it
let totalValue = 0;
const stockDataRows = document.querySelectorAll('#stockAtCost tbody tr');
stockDataRows.forEach(function(row) {
  if (row.querySelector('td:nth-child(4)')) {
    const cellValue = parseFloat(row.querySelector('td:nth-child(4)').textContent);
    if (!isNaN(cellValue)) {
      totalValue += cellValue;
    }
  }
});

// Check if totalValue is valid number
// Check if totalValue is valid number
if(isNaN(totalValue)) {
    document.querySelector('#totalCostValue').value = '';
  } else {
    document.querySelector('#totalCostValue').value = totalValue.toFixed(2);
  }  

// Enable save to PDF button if there is at least one row in the table
if (stockDataRows.length > 0) {
  document.querySelector('#saveCostResportPDFButton').removeAttribute('disabled');
}
        }
      }
      xhr.send('startDate=' + startDate + '&endDate=' + endDate);
    });
  });