$(document).ready(function() {
    // Handle form submit event
    $('#generateStockReport').submit(function(event) {
        event.preventDefault();

        var itemName = $('#itemName').val();

        // Send AJAX request to server to get stock cost data
        $.ajax({
            url: 'reports/get-stock-at-cost.php',
            method: 'POST',
            data: {
                itemName: itemName
            },
            dataType: 'json',
            success: function(response) {
                if(response.success) {
                    // Clear existing results from table
                    $('#stockCostResults').empty();

                    // Add new results to table
                    for(var i = 0; i < response.data.length; i++) {
                        var rowData = response.data[i];
                        var rowHtml = '<tr>' +
                            '<td>' + (i+1) + '</td>' +
                            '<td>' + rowData.serialNumber + '</td>' +
                            '<td>' + rowData.itemName + '</td>' +
                            '<td>' + rowData.description + '</td>' +
                            '<td>' + rowData.stock_level + '</td>' +
                            '<td>' + rowData.cost_price + '</td>' +
                            '<td>' + rowData.totalValue + '</td>' +
                            '</tr>';

                        console.log(rowHtml);
                        $('#stockCostResults').append(rowHtml);
                    }

                    // Set total cost value
                    $('#totalCostValue').val(response.totalCostValue);

                    // Enable PDF save button
                    $('#saveCostResportPDFButton').prop('disabled', false);

                    // Print success message to console
                    console.log('Stock cost report generated successfully!');
                } else {
                    // Print error message to console
                    console.error('Failed to generate report. Please try again later.');
                    alert('Failed to generate report. Please try again later.');
                }
            },
            error: function() {
                // Print error message to console
                console.error('Failed to connect to server. Please try again later.');
                alert('Failed to connect to server. Please try again later.');
            }
        });
    });

    // Handle PDF save button click event
    $('#saveCostResportPDFButton').click(function() {
        // TODO: Implement PDF generation and download
    });
});
