<?php
error_reporting(E_ALL);
include("../includes/DbConnect.php");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Get form data
    $start_date = $_POST['startDate'];
    $end_date = $_POST['endDate'];
    $cashierName = $_POST['cashierName'];
    $currencySymbol = $_POST['currencySymbol'];

    // Query to get sales items within date range
    $query_sales_items = "
    SELECT si.itemName, si.cost_price, SUM(si.quantity) AS quantity, SUM(si.unit_price) AS total_price, s.currencySymbol
    FROM tblsale_items si
    LEFT JOIN tblsales s ON si.sale_id = s.id
    WHERE s.saleDate BETWEEN :start_date AND :end_date
    AND s.cashierName = :cashierName";

    if ($currencySymbol) {
        $query_sales_items .= " AND s.currencySymbol = :currencySymbol";
    }

    $query_sales_items .= " GROUP BY si.itemName, si.cost_price, s.currencySymbol";

    $stmt_sales_items = $dbConn->prepare($query_sales_items);

    $stmt_sales_items->bindParam(':start_date', $start_date);
    $stmt_sales_items->bindParam(':end_date', $end_date);
    $stmt_sales_items->bindParam(':cashierName', $cashierName);

    if ($currencySymbol) {
        $stmt_sales_items->bindParam(':currencySymbol', $currencySymbol);
    }

    $stmt_sales_items->execute();

    $sales_items = $stmt_sales_items->fetchAll();

    $total_amount = 0;
    $total_cost = 0;
    foreach ($sales_items as $item) {
        $total_amount += $item['total_price'];
        $total_cost += (intval($item['quantity']) * floatval($item['cost_price']));
    }
    $net_profit = $total_amount - $total_cost;

    $currency_symbol = $sales_items[0]['currencySymbol'];
    $total_amount_formatted = number_format($total_amount, 2);
    $total_cost_formatted = number_format($total_cost, 2);
    $net_profit_formatted = number_format($net_profit, 2);

    $result = array(
        'sales_items' => $sales_items,
        'total_amount' => $total_amount_formatted,
        'total_cost' => $total_cost_formatted,
        'net_profit' => $net_profit_formatted,
        'currency_symbol' => $currency_symbol
    );
    echo json_encode($result);
    exit;
}