<?php 
	class PurchasesReturns {

		public $id;
		public $item;
		public $description;
		public $quantity;
		public $unitPrice;
		public $tax;
		public $amount;

		public $tableName = 'tbreturn_purchases';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function returnPurchases() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET item = :item, description = :description, quantity = :quantity, unitPrice = :unitPrice, tax = :tax, amount = :amount';

          	$myStatement = $this->dbConn->prepare($query);

          	$this->item = htmlspecialchars(strip_tags($this->item));
          	$this->description = htmlspecialchars(strip_tags($this->description));
          	$this->quantity = htmlspecialchars(strip_tags($this->quantity));
          	$this->unitPrice = htmlspecialchars(strip_tags($this->unitPrice));
          	$this->tax = htmlspecialchars(strip_tags($this->tax));
          	$this->amount = htmlspecialchars(strip_tags($this->amount));

          	$myStatement->bindParam(':item', $this->item);
          	$myStatement->bindParam(':description', $this->description);
          	$myStatement->bindParam(':quantity', $this->quantity);
          	$myStatement->bindParam(':unitPrice', $this->unitPrice);
          	$myStatement->bindParam(':tax', $this->tax);
          	$myStatement->bindParam(':amount', $this->amount);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

	}
 ?>