<?php 
	class Reconciliation {

		public $id;
		public $branch;
		public $customerName;
		public $dNoteNumber;
		public $invoiceNumber;
		public $folioNumber;
		public $stockNumber;
		public $balance;
		public $reconcileDate;

		public $tableName = 'tbldebtors_reconciliation';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function reconcile() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET branch = :branch, customerName = :customerName, dNoteNumber = :dNoteNumber, invoiceNumber = :invoiceNumber, folioNumber = :folioNumber, stockNumber = :stockNumber, balance = :balance, reconcileDate = :reconcileDate';
          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);
          	// Clean data
          	$this->branch = htmlspecialchars(strip_tags($this->branch));
          	$this->customerName = htmlspecialchars(strip_tags($this->customerName));
          	$this->dNoteNumber = htmlspecialchars(strip_tags($this->dNoteNumber));
          	$this->invoiceNumber = htmlspecialchars(strip_tags($this->invoiceNumber));
          	$this->folioNumber = htmlspecialchars(strip_tags($this->folioNumber));
          	$this->stockNumber = htmlspecialchars(strip_tags($this->stockNumber));
          	$this->balance = htmlspecialchars(strip_tags($this->balance));
          	$this->reconcileDate = htmlspecialchars(strip_tags($this->reconcileDate));

          	// Bind data
          	$myStatement->bindParam(':branch', $this->branch);
          	$myStatement->bindParam(':customerName', $this->customerName);
          	$myStatement->bindParam(':dNoteNumber', $this->dNoteNumber);
          	$myStatement->bindParam(':invoiceNumber', $this->invoiceNumber);
          	$myStatement->bindParam(':folioNumber', $this->folioNumber);
          	$myStatement->bindParam(':stockNumber', $this->stockNumber);
          	$myStatement->bindParam(':balance', $this->balance);
            $myStatement->bindParam(':reconcileDate', $this->reconcileDate);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

	}
 ?>