function addRow() {
  var table = document.getElementById("requisitionItem");
  var newRow = document.createElement("tr");
  newRow.innerHTML = `
    <td><input type="checkbox" class="itemRow custom-control-input" name="delete[]" id="itemRow_1"> <label class="custom-control-label" for="itemRow_1"></label></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="form-control" name="itemName[]" placeholder="item name" id="itemName"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="form-control" name="description[]" placeholder="description" id="description"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="number" class="quantity form-control" name="quantity[]" id="quantity_${table.rows.length}" placeholder="Quantity"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="number" class="itemCost form-control" name="itemCost[]" id="itemCost_${table.rows.length}" placeholder="item cost"></div></div></div></td>
  `;
  table.querySelector("tbody").appendChild(newRow);
  
  // attach event listeners to the new quantity and itemCost fields
  const itemCost = newRow.querySelector('.itemCost');
  itemCost.addEventListener('change', calculateTotalCost);
  
  const quantity = newRow.querySelector('.quantity');
  quantity.addEventListener('change', calculateTotalCost);
}

function deleteRow() {
  var table = document.getElementById("requisitionItem");
  var checkboxes = table.querySelectorAll('input[type="checkbox"][name="delete[]"]');
  for (var i = checkboxes.length - 1; i >= 0; i--) {
    if (checkboxes[i].checked) {
      table.deleteRow(i + 1);
    }
  }
  calculateTotalCost();
}

function calculateTotalCost() {
  const itemCosts = document.querySelectorAll('.itemCost');
  let totalCost = 0;

  itemCosts.forEach((itemCost) => {
    const quantity = itemCost.parentNode.parentNode.previousElementSibling.querySelector('.quantity').value;
    totalCost += parseFloat(itemCost.value) * parseInt(quantity);
  });

  const totalCostField = document.querySelector('.totalCost');
  if (totalCostField) {
    totalCostField.value = totalCost.toFixed(2);
  }
}

// attach event listeners to existing quantity and itemCost fields
const itemCosts = document.querySelectorAll('.itemCost');
itemCosts.forEach((itemCost) => {
  itemCost.addEventListener('change', calculateTotalCost);
});

const quantities = document.querySelectorAll('.quantity');
quantities.forEach((quantity) => {
  quantity.addEventListener('change', calculateTotalCost);
});

calculateTotalCost();
console.log(totalCost);