  document.addEventListener('DOMContentLoaded', function () {
    let convertBtn = document.querySelector('#convertQuotationToPDF');
    if (convertBtn) {
      convertBtn.addEventListener('click', function() {
        html2canvas(document.querySelector('#convertPreviewToPDF')).then((canvas) => {
          let base64image = canvas.toDataURL('image/png');
          let quoteNumber = document.querySelector('#quoteNumber').value;
          let pdfName = 'Quotation - ' + quoteNumber + '.pdf';
          
          let contentHeight = document.querySelector('#convertPreviewToPDF').offsetHeight;
          
          let pdf = new jsPDF('p', 'px', [1043.74, contentHeight]);
          
          pdf.addImage(base64image, 'PNG', 15, 15, 1043.74, contentHeight-30);
          
          pdf.save(pdfName);
        });
      });
    } else {
      console.log("Button not found");
    }
  });