function addRow() {
  var table = document.getElementById("purchaseOrderItem");
  var newRow = document.createElement("tr");
  newRow.innerHTML = `
    <td><input type="checkbox" class="itemRow custom-control-input" name="delete[]" id="itemRow_1"> <label class="custom-control-label" for="itemRow_1"></label></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="form-control" name="itemName[]" placeholder="item name" id="itemName"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="form-control" name="description[]" placeholder="description" id="description"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="number" class="unit_price form-control" name="unit_price[]" id="unit_price" onchange="calculateAmount()" placeholder="unit price"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="number" class="quantity form-control" name="quantity[]" id="quantity" onchange="calculateAmount()" placeholder="Quantity"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="tax form-control" name="tax[]" id="tax" onchange="calculateAmount()" placeholder="tax"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="amount form-control" name="amount[]" id="amount"></div></div></div></td>
  `;
  table.querySelector("tbody").appendChild(newRow);
}  
  function deleteRow() {
    var table = document.getElementById("purchaseOrderItem");
    var checkboxes = table.querySelectorAll('input[type="checkbox"][name="delete[]"]');
    for (var i = checkboxes.length - 1; i >= 0; i--) {
      if (checkboxes[i].checked) {
        table.deleteRow(i + 1);
      }
    }
  }

  function calculateAmount() {

    const rows = document.querySelectorAll('#purchaseOrderItem tbody tr');
  
    rows.forEach((row) => {
      const unitPriceInput = row.querySelector('.unit_price');
      const quantityInput = row.querySelector('.quantity');
      const taxInput = row.querySelector('.tax');
      const amountInput = row.querySelector('.amount');
  
      const unitPrice = parseFloat(unitPriceInput.value);
      const quantity = parseFloat(quantityInput.value);
      const tax = parseFloat(taxInput.value);
  
      if (isNaN(unitPrice) || isNaN(quantity) || isNaN(tax)) {
        amountInput.value = "";
        return;
      }
  
      const amount = (unitPrice * quantity) * (1 + (tax / 100));
  
      amountInput.value = amount.toFixed(2);
    });
  
    const amounts = Array.from(rows).map(row => parseFloat(row.querySelector('.amount').value));
    const totalAmount = amounts.reduce((acc, val) => acc + val, 0);
    document.querySelector('.totalAmount').value = totalAmount.toFixed(2);
  }