function addSaleRow() {
  var table = document.getElementById("saleItem");
  var newRow = document.createElement("tr");

  // Generate a unique ID for the checkbox input element
  var rowNumber = table.querySelectorAll("tbody tr").length + 1;
  var checkboxId = "itemRow_" + rowNumber;

  newRow.innerHTML = `
    <td><input type="checkbox" class="itemRow custom-control-input" name="delete[]" id="${checkboxId}"> <label class="custom-control-label" for="${checkboxId}"></label></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="form-control" name="item_name[]" placeholder="Item" id="item"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="unit_price form-control" name="unit_price[]" placeholder="Price" id="unit_price"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="quantity form-control" name="quantity[]" id="quantity" placeholder="Quantity"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="amount form-control" name="amount[]" id="amount" readonly=""></div></div></div></td>
  `;
  
  table.querySelector("tbody").appendChild(newRow);
}

function updateProduct(unit_price, quantity, amount) {
  if (!unit_price || !quantity || !amount) {
    return;
  }

  var priceValue = parseFloat(unit_price.value) || 0;
  var quantityValue = parseFloat(quantity.value) || 0;
  var amountValue = Math.round(priceValue * quantityValue * 100) / 100;

  amount.value = new Intl.NumberFormat('en-US').format(amountValue);

  var table = document.getElementById("saleItem");
  var allTotals = table.querySelectorAll(".amount");
  var totalAmount = 0;

  for (var i = 0; i < allTotals.length; i++) {
    var currentTotal = parseFloat(allTotals[i].value.replace(/,/g, ""));
    if (!isNaN(currentTotal)) {
      totalAmount += currentTotal;
    }
  }

  var totalAmountField = document.getElementById("grandTotal");
  
  totalAmountField.value = new Intl.NumberFormat('en-US').format(totalAmount.toFixed(2));

  updateChange();
}


document.addEventListener("input", function (event) {
  var row = event.target.closest("tr");
  if (row) {
    var unit_price = row.querySelector(".unit_price");
    var quantity = row.querySelector(".quantity");
    var amount = row.querySelector(".amount");
    updateProduct(unit_price, quantity, amount);
  }
});

function updateChange() {
  var grandTotal = document.getElementById("grandTotal").value.trim().replace(/,/g, '');
  var amountPaid = document.getElementById("amountPaid").value.trim().replace(/,/g, ''); // Remove commas

  // Validate the input values
  if (grandTotal === "" || isNaN(Number(grandTotal))) {
    document.getElementById("changeResult").value = "Invalid input: Grand Total";
    return;
  }
  
  if (amountPaid === "" || isNaN(Number(amountPaid))) {
    document.getElementById("changeResult").value = "Invalid input: Amount Paid";
    return;
  }

  var changeResult = (Number(amountPaid) ?? 0) - (Number(grandTotal) ?? 0);

  // Format the result with commas and point
  var formattedResult = new Intl.NumberFormat('en-US').format(changeResult.toFixed(2));
  document.getElementById("changeResult").value = formattedResult;
}

function deleteSaleRows() {
  var table = document.getElementById("saleItem");
  var checkboxes = table.querySelectorAll('input[type="checkbox"][name="delete[]"]');
  for (var i = checkboxes.length - 1; i >= 0; i--) {
    if (checkboxes[i].checked) {
      table.deleteRow(i + 1);
    }
  }
  var allTotals = table.querySelectorAll(".amount");
  var grandTotal = 0;

  for (var i = 0; i < allTotals.length; i++) {
    var currentTotal = parseFloat(allTotals[i].value.replace(/,/g, ""));
    if (!isNaN(currentTotal)) {
      grandTotal += currentTotal;
    }
  }

  var grandTotalField = document.getElementById("grandTotal");

  // Format the result with commas and point
  grandTotalField.value = new Intl.NumberFormat('en-US').format(grandTotal.toFixed(2));
}

function searchItem() {
  const serialNumber = document.getElementById("serialNumber").value;
  $.ajax({
    url: 'functions/search-items.php',
    type: 'POST',
    data: {
      serialNumber: serialNumber
    },
    success: function(data) {
      if (data.trim() === '') {
        alert('No products found.');
      } else {
        $('#saleItem tbody').append(data);
      }
    },
    error: function(_xhr, _status, error) {
      alert('An error occurred while searching for the product: ' + error);
    }
  });  
}

function handleCurrencyConversion() {
  const currency = document.getElementById("currency").value;
  const amount = document.getElementById("amount").value;
  const unit_price = document.getElementsByName("unit_price[]");
  const quantity = document.getElementsByName("quantity[]");
  const amountFields = document.getElementsByName("amount[]");
  const grandTotalField = document.getElementById("grandTotal");
  const changeResultField = document.getElementById("changeResult");

  fetch(`my_api/point-of-sale/currency-conveter-api.php?currency=${currency}&amount=${amount}`)
    .then(res => {
      if (!res.ok) {
        throw new Error("Failed to convert currency.");
      }
      return res.json();
    })
    .then(data => {
      console.log("API response:", data); // New line for debugging purposes

      const rate = data.rates[currency];
      const converted_amount = (rate * parseFloat(amount)).toFixed(2);

      var convertedtotalAmount = 0;
      
      if (unit_price.length !== quantity.length || quantity.length !== amountFields.length) {
        console.error("Array lengths do not match.");
        return;
      }

      for (var i = 0; i < unit_price.length; i++) {

        console.log("unit_price length:", unit_price.length); // New line for debugging purposes
        console.log("quantity length:", quantity.length); // New line for debugging purposes
        
        const converted_price = (rate * parseFloat(unit_price[i].value)).toFixed(2);
        const converted_total_amount = (converted_price * parseFloat(quantity[i].value)).toFixed(2);
        
        // Update the price field value for this row
        unit_price[i].value = new Intl.NumberFormat('en-US').format(converted_price);
        
        // Update the amount field value for this row
        amountFields[i].value = new Intl.NumberFormat('en-US').format(converted_total_amount);

        convertedtotalAmount += parseFloat(converted_total_amount);
      }

      console.log("convertedtotalAmount:", convertedtotalAmount); // New line for debugging purposes
      
      grandTotalField.value = new Intl.NumberFormat('en-US').format(convertedtotalAmount.toFixed(2));
      changeResultField.value = `${new Intl.NumberFormat('en-US').format(amount)} ${currency} = ${new Intl.NumberFormat('en-US').format(converted_amount)} USD`;

      updateChange();
    })
    .catch(err => {
      console.error(err);
      setTimeout(handleCurrencyConversion, 1000); // Retry after 1 second
      alert("Failed to convert currency. Retrying...");
    });
}