function addRow() {
  var table = document.getElementById("invoceItem");
  var newRow = document.createElement("tr");
  newRow.innerHTML = `
    <td><input type="checkbox" class="itemRow custom-control-input" name="delete[]" id="itemRow_1"> <label class="custom-control-label" for="itemRow_1"></label></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="form-control" name="item" placeholder="Item" id="item_1"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="number" class="price form-control" name="price" placeholder="Price" id="price"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="number" class="quantity form-control" name="quantity" id="quantity" placeholder="Quantity"></div></div></div></td>
  <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="amount form-control" name="amount" value="" id="amount" readonly=""></div></div></div></td>`;
  table.querySelector("tbody").appendChild(newRow);
}

function updateItem(price, quantity, amount) {
  if (!price || !quantity || !amount) {
    return;
  }
  var priceValue = parseFloat(price.value) || 0;
  var quantityValue = parseFloat(quantity.value) || 0;
  amount.value = (priceValue * quantityValue).toFixed(2);

  var table = document.getElementById("invoiceItem");
  var allTotals = table.querySelectorAll(".amount");
  var grandTotal = 0;

  for (var i = 0; i < allTotals.length; i++) {
    var currentTotal = parseFloat(allTotals[i].value);
    if (!isNaN(currentTotal)) {
      grandTotal += currentTotal;
    }
  }
  var grandTotalField = document.getElementById("grandTotal");
  grandTotalField.value = grandTotal.toFixed(2);
}

document.addEventListener("input", function (event) {
  var row = event.target.closest("tr");
  if (row) {
    var price = row.querySelector(".price");
    var quantity = row.querySelector(".quantity");
    var amount = row.querySelector(".amount");
    updateItem(price, quantity, amount);
  }
});

function deleteInvoiceRows() {
  var table = document.getElementById("invoiceItem");
  var checkboxes = table.querySelectorAll('input[type="checkbox"][name="delete[]"]');
  for (var i = checkboxes.length - 1; i >= 0; i--) {
    if (checkboxes[i].checked) {
      table.deleteRow(i + 1);
    }
  }
  var allTotals = table.querySelectorAll(".amount");
  var grandTotal = 0;

  for (var i = 0; i < allTotals.length; i++) {
    var currentTotal = parseFloat(allTotals[i].value);
    if (!isNaN(currentTotal)) {
      grandTotal += currentTotal;
    }
  }

  var grandTotalField = document.getElementById("grandTotal");
  grandTotalField.value = grandTotal.toFixed(2);
}

 
