<?php 
	class DeliveryNote {

		public $id;
		public $deliveryDate;
		public $coyName;
		public $coyEmail;
		public $coyPhone;
		public $coyAddress;
		public $customerName;
		public $customerEmail;
		public $customerPhone;
		public $customerAddress;
		public $item;
		public $description;
		public $quantity;
		public $status;

		public $tableName = 'delivery';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function addNote() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET deliveryDate = :deliveryDate, coyName = :coyName, coyEmail = :coyEmail, coyPhone = :coyPhone, coyAddress = :coyAddress, customerName = :customerName, customerEmail = :customerEmail, customerPhone = :customerPhone, customerAddress = :customerAddress, item = :item, description = :description, quantity = :quantity, status = :status';
          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);
          	// Clean data
          	$this->deliveryDate = htmlspecialchars(strip_tags($this->deliveryDate));
          	$this->coyName = htmlspecialchars(strip_tags($this->coyName));
          	$this->coyEmail = htmlspecialchars(strip_tags($this->coyEmail));
          	$this->coyPhone = htmlspecialchars(strip_tags($this->coyPhone));
          	$this->coyAddress = htmlspecialchars(strip_tags($this->coyAddress));
          	$this->customerName = htmlspecialchars(strip_tags($this->customerName));
          	$this->customerEmail = htmlspecialchars(strip_tags($this->customerEmail));
          	$this->customerPhone = htmlspecialchars(strip_tags($this->customerPhone));
          	$this->customerAddress = htmlspecialchars(strip_tags($this->customerAddress));
          	$this->item = htmlspecialchars(strip_tags($this->item));
          	$this->description = htmlspecialchars(strip_tags($this->description));
          	$this->quantity = htmlspecialchars(strip_tags($this->quantity));
          	$this->status = htmlspecialchars(strip_tags($this->status));

          	// Bind data
          	$myStatement->bindParam(':deliveryDate', $this->deliveryDate);
          	$myStatement->bindParam(':coyName', $this->coyName);
          	$myStatement->bindParam(':coyEmail', $this->coyEmail);
          	$myStatement->bindParam(':coyPhone', $this->coyPhone);
          	$myStatement->bindParam(':coyAddress', $this->coyAddress);
          	$myStatement->bindParam(':customerName', $this->customerName);
          	$myStatement->bindParam(':customerEmail', $this->customerEmail);
          	$myStatement->bindParam(':customerPhone', $this->customerPhone);
          	$myStatement->bindParam(':customerAddress', $this->customerAddress);
          	$myStatement->bindParam(':item', $this->item);
			$myStatement->bindParam(':description', $this->description);
			$myStatement->bindParam(':quantity', $this->quantity);
			$myStatement->bindParam(':status', $this->status);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

	}
 ?>