<?php 
	class Products {

		public $id;
		public $serialNumber;
		public $item;
		public $description;
		public $size;
		public $price;
		public $quantity;
		public $created_on;
		public $updated_on;

		public $tableName = 'products';
		public $dbConn;


		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function addProduct() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET serialNumber = :serialNumber, item = :item, description = :description, size = :size, quantity = :quantity, price = :price';

          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);

          	// Clean data
          	$this->serialNumber = htmlspecialchars(strip_tags($this->serialNumber));
          	$this->item = htmlspecialchars(strip_tags($this->item));
          	$this->description = htmlspecialchars(strip_tags($this->description));
          	$this->size = htmlspecialchars(strip_tags($this->size));
          	$this->quantity = htmlspecialchars(strip_tags($this->quantity));
          	$this->price = htmlspecialchars(strip_tags($this->price));

          	// Bind data
          	$myStatement->bindParam(':serialNumber', $this->serialNumber);
          	$myStatement->bindParam(':item', $this->item);
			$myStatement->bindParam(':description', $this->description);
			$myStatement->bindParam(':size', $this->size);
			$myStatement->bindParam(':quantity', $this->quantity);
			$myStatement->bindParam(':price', $this->price);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}
	}
 ?>