<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

 include_once '../config/DbConnect.php';
 include_once '../config/jwt.php';
 include_once '../functions/status_codes.php';

//Customers/users Table
$tableName = 'customers';
$email = '';
$password = '';

$db = new DbConnect();
$dbConn = $db->connect();
//Get Raw Data
$data = json_decode(file_get_contents("php://input"));

$email = $data->email;
$password = $data->password;

$query = "SELECT * FROM " . $tableName . " WHERE email = :email LIMIT 1";

$myStatement = $dbConn->prepare( $query );
$myStatement->bindParam(':email', $email);
$myStatement->execute();
$result = $myStatement->rowCount();

if($result > 0){
    $row = $myStatement->fetch(PDO::FETCH_ASSOC);
    $customerId = $row['customerId'];
    $customerName = $row['name'];
    $getCustomerPassword = $row['password'];

    if(password_verify($password, $getCustomerPassword)){
        $payload = array(
            "iss" => "localhost",
            "iat" => time(),
            "exp" => time() + (5*60),//5 Minutes limit
            "data" => array(
                "customerId" => $customerId,
                "name" => $customerName,
                "email" => $email
        ));

        $token = JWT::encode($payload, SECRETE_KEY);
        echo json_encode(
            array(['Status' => SUCCESS_RESPONSE,'message' => 'Logged in Successfully...',
                "token" => $token,
        ])
        );
    }else{
        //echo $data;
    echo json_encode(
      array(['Status' => ERROR,'message' => 'Login failed, Incorrect Password...'])
    );
    }}else{
    echo json_encode(
      array(['Status' => USER_NOT_FOUND,'message' => 'User not found, Register first before you try to Login...'])
    );
    }
?>