<?php
error_reporting(E_ALL);
include("../includes/DbConnect.php");
$itemName = $_POST["itemName"];

// Prepare SQL statement to get stock cost data
$sql = "SELECT 
            id, 
            serialNumber, 
            itemName, 
            description, 
            stock_level, 
            cost_price, 
            (stock_level * cost_price) as totalValue
        FROM 
            tblpos_stock
        WHERE 
            itemName = :itemName";

// Prepare the statement
$stmt = $dbConn->prepare($sql);
$stmt->bindParam(":itemName", $itemName);

// Execute the query
$stmt->execute();

// Get the results
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Calculate total cost value
$totalCostValue = 0;
foreach($results as $result) {
    $totalCostValue += $result["totalValue"];
}

// Create the response object
$response = new stdClass();
$response->success = true;
$response->data = $results;
$response->totalCostValue = $totalCostValue;

// Return the response as JSON
header('Content-Type: application/json');
echo json_encode($response);
?>
