<?php 
	class PurchaseOrder {

		public $orderDate;
          public $supplierName;
          public $supplierEmail;
          public $supplierPhone;
          public $physicalAddress;
          public $item;
		public $description;
		public $quantity;
		public $unitPrice;
		public $tax;
		public $amount;

		public $tableName = 'tbpurchase_orders';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function addOrder() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET orderDate = :orderDate, physicalAddress = :physicalAddress, supplierPhone = :supplierPhone, supplierEmail = :supplierEmail, supplierName = :supplierName, item = :item, description = :description, quantity = :quantity, unitPrice = :unitPrice, tax = :tax, amount = :amount';
          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);
          	
               $this->orderDate = htmlspecialchars(strip_tags($this->orderDate));
               $this->physicalAddress = htmlspecialchars(strip_tags($this->physicalAddress));
               $this->supplierPhone = htmlspecialchars(strip_tags($this->supplierPhone));
               $this->supplierEmail = htmlspecialchars(strip_tags($this->supplierEmail));
               $this->supplierName = htmlspecialchars(strip_tags($this->supplierName));
          	$this->item = htmlspecialchars(strip_tags($this->item));
          	$this->description = htmlspecialchars(strip_tags($this->description));
          	$this->quantity = htmlspecialchars(strip_tags($this->quantity));
          	$this->unitPrice = htmlspecialchars(strip_tags($this->unitPrice));
          	$this->tax = htmlspecialchars(strip_tags($this->tax));
          	$this->amount = htmlspecialchars(strip_tags($this->amount));

               $myStatement->bindParam(':orderDate', $this->orderDate);
               $myStatement->bindParam(':physicalAddress', $this->physicalAddress);
               $myStatement->bindParam(':supplierEmail', $this->supplierEmail);
               $myStatement->bindParam(':supplierPhone', $this->supplierPhone);
               $myStatement->bindParam(':supplierName', $this->supplierName);
          	$myStatement->bindParam(':item', $this->item);
          	$myStatement->bindParam(':description', $this->description);
          	$myStatement->bindParam(':quantity', $this->quantity);
          	$myStatement->bindParam(':unitPrice', $this->unitPrice);
          	$myStatement->bindParam(':tax', $this->tax);
          	$myStatement->bindParam(':amount', $this->amount);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

	}
 ?>