document.addEventListener('DOMContentLoaded', function () {
  let convertBtn = document.querySelector('#convertQuotationToPDF');
  if (convertBtn) {
    convertBtn.addEventListener('click', function() {
      let element = document.querySelector('#convertPreviewToPDF');
      let quoteNumber = document.querySelector('#quoteNumber').value;
      let pdfName = 'Quotations -' + quoteNumber + '.pdf';

      // Hide the buttons from the HTML form
      let buttons = document.querySelectorAll('.pdf-buttons');
      if (buttons) {
        buttons.forEach(button => button.style.display = 'none');
      }

      // Use html2pdf.js to convert the HTML content to a PDF
      html2pdf().from(element).set({
        margin: [10, 10, 10, 10],
        filename: pdfName,
        html2canvas: {
          scale: 2,
          useCORS: true,
          background: '#fff'
        },
        jsPDF: {
          unit: 'mm',
          format: 'a4',
          orientation: 'portrait'
        }
      }).save();

      // Restore the buttons to the HTML form
      if (buttons) {
        buttons.forEach(button => button.style.display = 'block');
      }
    });
  } else {
    console.log("Button not found");
  }
});