          document.addEventListener('DOMContentLoaded', function () {
            let convertBtn = document.querySelector('#convertQuotationToPDF');
            if (convertBtn) {
                convertBtn.addEventListener('click', function() {
                    let element = document.querySelector('#convertPreviewToPDF');
                    let quoteNumber = document.querySelector('#quoteNumber').value;
                    let pdfName = 'Quotations -' + quoteNumber + '.pdf';
        
                    // Hide the buttons from the HTML form
                    let buttons = document.querySelectorAll('.pdf-buttons');
                    if (buttons) {
                        buttons.forEach(button => button.style.display = 'none');
                    }
        
                    html2canvas(element, { useCORS: true, background: true }).then(canvas => {
        
                        let imgWidth = 210;
                        let pageHeight = 295;
                        let imgHeight = Math.floor(canvas.height * imgWidth / canvas.width);
                        let heightLeft = imgHeight;
        
                        const contentDataURL = canvas.toDataURL('image/png');
                        let pdf = new jsPDF('p', 'mm', 'a4');
                        let position = 0;
        
                        pdf.addImage(contentDataURL, 'PNG', 0, position, imgWidth, imgHeight);
        
                        // Save the modified PDF to a new file
                        pdf.save(pdfName);
        
                        // Restore the buttons to the HTML form
                        if (buttons) {
                            buttons.forEach(button => button.style.display = 'block');
                        }
        
                    });
                });
            } else {
                console.log("Button not found");
            }
        });