<?php
include("../includes/DbConnect.php");
$startDate = $_POST['startDate'];
$endDate = $_POST['endDate'];

// Retrieve data using prepared statements
$salesQuery = "SELECT SUM(totalAmount) AS total_sales, currencySymbol FROM tblsales WHERE saleDate BETWEEN :startDate AND :endDate GROUP BY currencySymbol";
$salesStmt = $dbConn->prepare($salesQuery);
$salesStmt->execute(['startDate' => $startDate, 'endDate' => $endDate]);
$salesData = $salesStmt->fetchAll(PDO::FETCH_ASSOC);

$paymentQuery = "SELECT SUM(amount) AS total_payments, currencySymbol FROM paymentbills WHERE paymentDate BETWEEN :startDate AND :endDate GROUP BY currencySymbol";
$paymentStmt = $dbConn->prepare($paymentQuery);
$paymentStmt->execute(['startDate' => $startDate, 'endDate' => $endDate]);
$paymentData = $paymentStmt->fetchAll(PDO::FETCH_ASSOC);

$stockQuery = "SELECT SUM(cost_price) AS total_stock, currencySymbol FROM tblreceive_items_items WHERE receivedDate BETWEEN :startDate AND :endDate GROUP BY currencySymbol";
$stockStmt = $dbConn->prepare($stockQuery);
$stockStmt->execute(['startDate' => $startDate, 'endDate' => $endDate]);
$stockData = $stockStmt->fetchAll(PDO::FETCH_ASSOC);

$issueStockQuery = "SELECT SUM(cost_price) AS total_issued_stock, currencySymbol FROM tbfinished_products_dispatch WHERE dispatchDate BETWEEN :startDate AND :endDate GROUP BY currencySymbol";
$issueStockStmt = $dbConn->prepare($issueStockQuery);
$issueStockStmt->execute(['startDate' => $startDate, 'endDate' => $endDate]);
$issueStockData = $issueStockStmt->fetchAll(PDO::FETCH_ASSOC);

$salaryQuery = "SELECT SUM(salaryAmount) AS total_salary, currencySymbol FROM paymentsalaries WHERE salaryDate BETWEEN :startDate AND :endDate GROUP BY currencySymbol";
$salaryStmt = $dbConn->prepare($salaryQuery);
$salaryStmt->execute(['startDate' => $startDate, 'endDate' => $endDate]);
$salaryData = $salaryStmt->fetchAll(PDO::FETCH_ASSOC);

$inventoryQuery = "SELECT SUM(cost_price) AS total_inventory, currencySymbol FROM tb_stores_inventory WHERE addedOn BETWEEN :startDate AND :endDate GROUP BY currencySymbol";
$inventoryStmt = $dbConn->prepare($inventoryQuery);
$inventoryStmt->execute(['startDate' => $startDate, 'endDate' => $endDate]);
$inventoryData = $inventoryStmt->fetchAll(PDO::FETCH_ASSOC);

// Calculate net cash flow from operations
$salesDataBycurrencySymbol = array();
$paymentDataBycurrencySymbol = array();
$stockDataBycurrencySymbol = array();
$issueStockDataBycurrencySymbol = array();
$salaryDataBycurrencySymbol = array();
$inventoryDataBycurrencySymbol = array();

foreach ($salesData as $salesRow) {
    $currencySymbol = $salesRow['currencySymbol'];
    if (!isset($salesDataBycurrencySymbol[$currencySymbol])) {
        $salesDataBycurrencySymbol[$currencySymbol] = 0;
    }
    $salesDataBycurrencySymbol[$currencySymbol] += $salesRow['total_sales'];
}

foreach ($paymentData as $paymentRow) {
    $currencySymbol = $paymentRow['currencySymbol'];
    if (!isset($paymentDataBycurrencySymbol[$currencySymbol])) {
        $paymentDataBycurrencySymbol[$currencySymbol] = 0;
    }
    $paymentDataBycurrencySymbol[$currencySymbol] += $paymentRow['total_payments'];
}

foreach ($stockData as $stockRow) {
    $currencySymbol = $stockRow['currencySymbol'];
    if (!isset($stockDataBycurrencySymbol[$currencySymbol])) {
        $stockDataBycurrencySymbol[$currencySymbol] = 0;
    }
    $stockDataBycurrencySymbol[$currencySymbol] += $stockRow['total_stock'];
}

foreach ($issueStockData as $issueStockRow) {
    $currencySymbol = $issueStockRow['currencySymbol'];
    if (!isset($issueStockDataBycurrencySymbol[$currencySymbol])) {
        $issueStockDataBycurrencySymbol[$currencySymbol] = 0;
    }
    $issueStockDataBycurrencySymbol[$currencySymbol] += $issueStockRow['total_issued_stock'];
}

foreach ($salaryData as $salaryRow) {
    $currencySymbol = $salaryRow['currencySymbol'];
    if (!isset($salaryDataBycurrencySymbol[$currencySymbol])) {
        $salaryDataBycurrencySymbol[$currencySymbol] = 0;
    }
    $salaryDataBycurrencySymbol[$currencySymbol] += $salaryRow['total_salary'];
}

foreach ($inventoryData as $inventoryRow) {
    $currencySymbol = $inventoryRow['currencySymbol'];
    if (!isset($inventoryDataBycurrencySymbol[$currencySymbol])) {
        $inventoryDataBycurrencySymbol[$currencySymbol] = 0;
    }
    $inventoryDataBycurrencySymbol[$currencySymbol] += $inventoryRow['total_inventory'];
}

$netCashFlowFromOperationsBycurrencySymbol = array();
foreach ($salesDataBycurrencySymbol as $currencySymbol => $totalSales) {
    $netCashFlowFromOperationsBycurrencySymbol[$currencySymbol] = ($totalSales + (isset($paymentDataBycurrencySymbol[$currencySymbol]) ? $paymentDataBycurrencySymbol[$currencySymbol] : 0)) - ((isset($stockDataBycurrencySymbol[$currencySymbol]) ? $stockDataBycurrencySymbol[$currencySymbol] : 0) + (isset($issueStockDataBycurrencySymbol[$currencySymbol]) ? $issueStockDataBycurrencySymbol[$currencySymbol] : 0) + (isset($salaryDataBycurrencySymbol[$currencySymbol]) ? $salaryDataBycurrencySymbol[$currencySymbol] : 0));
}

// Print the table with results
echo '<table>
    <tr>
        <th>OPERATIONS</th>
        <th></th>
        <th align="right">AMOUNT</th>
    </tr>';

// Cash receipts from
echo '<tr>
        <td><b>Cash receipts from:</b></td>
        <td> </td>
        <td></td>
    </tr>';

foreach ($salesDataBycurrencySymbol as $currencySymbol => $totalSales) {
    echo '<tr>
            <td style="padding-left: 55px;">Customers (' . $currencySymbol . ')</td>
            <td> </td>
            <td>'. number_format($totalSales, 2) . '</td>
        </tr>';
}

foreach ($paymentDataBycurrencySymbol as $currencySymbol => $totalPayments) {
    echo '<tr>
            <td style="padding-left: 55px;">Other Operations (' . $currencySymbol . ')</td>
            <td> </td>
            <td>' . number_format($totalPayments, 2) . '</td>
        </tr>';
}

// Cash paid for
echo '<tr>
        <td><b>Cash paid for:</b></td>
        <td> </td>
        <td></td>
    </tr>';

foreach ($stockDataBycurrencySymbol as $currencySymbol => $totalStock) {
    echo '<tr>
            <td style="padding-left: 55px;">Inventory Purchases (' . $currencySymbol . ')</td>
            <td> </td>
            <td>' . number_format($totalStock, 2) . '</td>
        </tr>';
}

echo '<tr>
        <td style="padding-left:55px;">General Operating & Administrative Expenses</td>
        <td> </td>
        <td>$0.00</td>
    </tr>';

foreach ($salaryDataBycurrencySymbol as $currencySymbol => $totalSalary) {
    echo '<tr>
            <td style="padding-left: 55px;">Wages & Salaries Expenses (' . $currencySymbol . ')</td>
            <td> </td>
            <td>' . number_format($totalSalary, 2) . '</td>
        </tr>';
}

// Net cash flow from operations
echo '<tr class="total">
        <td>NET CASH FLOW FROM OPERATIONS</td>
        <td> </td>
        <td></td>
    </tr>';
foreach ($netCashFlowFromOperationsBycurrencySymbol as $currencySymbol => $netCashFlowFromOperations) {
    echo '<tr>
            <td style="padding-left: 55px;"></td>
            <td> </td>
            <td><b>(' . $currencySymbol . ')</b> ' . number_format($netCashFlowFromOperations, 2) . '</td>
        </tr>';
}

echo '</table><br><table>
    <tr>
        <th>FINANCING ACTIVITIES</th>
        <th></th>
        <th align="right">AMOUNT</th>
    </tr>';

// Cash receipts from
echo '<tr>
        <td><b>Cash receipts from:</b></td>
        <td> </td>
        <td></td>
    </tr>';

foreach ($issueStockDataBycurrencySymbol as $currencySymbol => $totalIssuedStock) {
    echo '<tr>
            <td style="padding-left: 55px;">Issuance Stock (' . $currencySymbol . ')</td>
            <td> </td>
            <td>' . number_format($totalIssuedStock, 2) . '</td>
        </tr>';
}

echo '<tr>
        <td style="padding-left: 55px;">Borrowing</td>
        <td> </td>
        <td>$0.00</td>
    </tr>';

// Cash paid for
echo '<tr>
        <td><b>Cash paid for:</b></td>
        <td> </td>
        <td></td>
    </tr>';

echo '<tr>
        <td style="padding-left: 55px;">Re-Purchase of Stock</td>
        <td> </td>
        <td>' . number_format(0, 2) . '</td>
    </tr>';

// Net cash flow from financing activities
$netCashFlowFromFinancingActivitiesBycurrencySymbol = array();
foreach ($issueStockDataBycurrencySymbol as $currencySymbol => $totalIssuedStock) {
    $netCashFlowFromFinancingActivitiesBycurrencySymbol[$currencySymbol] = $totalIssuedStock;
}
echo '<tr class="total">
        <td>NET CASH FLOW FROM FINANCING ACTIVITIES</td>
        <td> </td>
        <td></td>
    </tr>';
foreach ($netCashFlowFromFinancingActivitiesBycurrencySymbol as $currencySymbol => $netCashFlowFromFinancingActivities) {
    echo '<tr>
            <td style="padding-left: 55px;"></td>
            <td> </td>
            <td><b>(' . $currencySymbol . ')</b> ' . number_format($netCashFlowFromFinancingActivities, 2) . '</td>
        </tr>';
}

// Net cash increase and cash at year end
$netCashIncreaseBycurrencySymbol = array();
$cashAtYearEndBycurrencySymbol = array();
foreach (array_keys($netCashFlowFromOperationsBycurrencySymbol + $netCashFlowFromFinancingActivitiesBycurrencySymbol) as $currencySymbol) {
    $netCashIncreaseBycurrencySymbol[$currencySymbol] = (isset($netCashFlowFromOperationsBycurrencySymbol[$currencySymbol]) ? $netCashFlowFromOperationsBycurrencySymbol[$currencySymbol] : 0) + (isset($netCashFlowFromFinancingActivitiesBycurrencySymbol[$currencySymbol]) ? $netCashFlowFromFinancingActivitiesBycurrencySymbol[$currencySymbol] : 0);
    $cashAtYearEndBycurrencySymbol[$currencySymbol] = $netCashIncreaseBycurrencySymbol[$currencySymbol];
}
echo '<tr>
        <th>NET CASH INCREASE</th>
        <th></th>
        <th align="right"></th>
    </tr>';
foreach ($netCashIncreaseBycurrencySymbol as $currencySymbol => $netCashIncrease) {
    echo '<tr>
            <td style="padding-left: 55px;"></td>
            <td> </td>
            <td><b>(' . $currencySymbol . ')</b> ' . number_format($netCashIncrease, 2) . '</td>
        </tr>';
}

echo '<tr>
        <th>CASH AT YEAR END</th>
        <th></th>
        <th align="right"></th>
    </tr>';
foreach ($cashAtYearEndBycurrencySymbol as $currencySymbol => $cashAtYearEnd) {
    echo '<tr>
            <td style="padding-left: 55px;"></td>
            <td> </td>
            <td><b>(' . $currencySymbol . ')</b> ' . number_format($cashAtYearEnd, 2) . '</td>
        </tr>';
}

echo '</table><br><br>';