<?php
include("../includes/DbConnect.php");
$startDate = $_POST['startDate'];
$endDate = $_POST['endDate'];

$bankAccountQuery = $dbConn->prepare("SELECT accountNumber, SUM(openingBalance) as total, currencySymbol FROM openaccounts GROUP BY id");
$bankAccountQuery->execute();
$result1 = $bankAccountQuery->fetchAll();

$billsQuery = $dbConn->prepare("SELECT chartOfAccounts, billType, amount, currencySymbol FROM paymentbills WHERE paymentDate BETWEEN :startDate AND :endDate");
$billsQuery->execute(['startDate' => $startDate, 'endDate' => $endDate]);
$result2 = $billsQuery->fetchAll();

$salariesQuery = $dbConn->prepare("SELECT employeeName, salaryAmount, currencySymbol FROM paymentsalaries WHERE salaryDate BETWEEN :startDate AND :endDate");
$salariesQuery->execute(['startDate' => $startDate, 'endDate' => $endDate]);
$result3 = $salariesQuery->fetchAll();

$jobCostingQuery = $dbConn->prepare("SELECT item, SUM(amount) as total, currencySymbol FROM jobcosting WHERE productionDate BETWEEN :startDate AND :endDate GROUP BY item, currencySymbol");
$jobCostingQuery->execute(['startDate' => $startDate, 'endDate' => $endDate]);
$result4 = $jobCostingQuery->fetchAll();

$posStockQuery = $dbConn->prepare("
    SELECT itemName, stock_level, unit_price, 
           (CASE WHEN stock_level >= 0 THEN stock_level * unit_price ELSE 0 END) as total, currencySymbol
    FROM tblpos_stock
    WHERE stock_level >= 0
");
$posStockQuery->execute();
$result5 = $posStockQuery->fetchAll();

// Calculate the totals for Assets
$assets = array();

foreach($result1 as $row) {
  if(!isset($assets[$row['currencySymbol']])) {
      $assets[$row['currencySymbol']] = array();
  }
  if(!isset($assets[$row['currencySymbol']]['cashAndEquivalentsTotal'])) {
      $assets[$row['currencySymbol']]['cashAndEquivalentsTotal'] = 0;
  }
  $assets[$row['currencySymbol']]['cashAndEquivalentsTotal'] += $row['total'];
}

foreach($result2 as $row) {
    if(!isset($assets[$row['currencySymbol']])) {
        $assets[$row['currencySymbol']] = array();
    }
    if($row['chartOfAccounts'] == 'Accounts Receivable') {
        $assets[$row['currencySymbol']]['accountsReceivableTotal'] = $row['amount'];
    } else {
        if(!isset($assets[$row['currencySymbol']]['billsTotal'])) {
            $assets[$row['currencySymbol']]['billsTotal'] = 0;
        }
        $assets[$row['currencySymbol']]['billsTotal'] += $row['amount'];
    }
}

foreach($result5 as $row) {
    if(!isset($assets[$row['currencySymbol']])) {
        $assets[$row['currencySymbol']] = array();
    }
    if(!isset($assets[$row['currencySymbol']]['inventoryTotal'])) {
        $assets[$row['currencySymbol']]['inventoryTotal'] = 0;
    }
    $assets[$row['currencySymbol']]['inventoryTotal'] += $row['total'];
}

// Calculate the total assets for each currency
$assetsTotals = array();

foreach($assets as $currencySymbol => $values) {
    $assetsTotals[$currencySymbol] = 0;
    foreach($values as $value) {
        $assetsTotals[$currencySymbol] += $value;
    }
}

// Calculate the totals for Liabilities and Equity
$liabilitiesAndEquity = array();

foreach($result2 as $row) {
    if(!isset($liabilitiesAndEquity[$row['currencySymbol']])) {
        $liabilitiesAndEquity[$row['currencySymbol']] = array();
    }
    if($row['chartOfAccounts'] == 'Accounts Payable') {
        $liabilitiesAndEquity[$row['currencySymbol']]['accountsPayableTotal'] = $row['amount'];
    } elseif($row['chartOfAccounts'] == 'Taxes Payable') {
        $liabilitiesAndEquity[$row['currencySymbol']]['taxesPayableTotal'] = $row['amount'];
    }
}

foreach($result3 as $row) {
    if(!isset($liabilitiesAndEquity[$row['currencySymbol']])) {
        $liabilitiesAndEquity[$row['currencySymbol']] = array();
    }
    if(!isset($liabilitiesAndEquity[$row['currencySymbol']]['salariesPayableTotal'])) {
        $liabilitiesAndEquity[$row['currencySymbol']]['salariesPayableTotal'] = 0;
    }
    $liabilitiesAndEquity[$row['currencySymbol']]['salariesPayableTotal'] += $row['salaryAmount'];
}

// Calculate the total liabilities and equity for each currency
$liabilitiesAndEquityTotals = array();

foreach($liabilitiesAndEquity as $currencySymbol => $values) {
    $liabilitiesAndEquityTotals[$currencySymbol] = 0;
    foreach($values as $value) {
        $liabilitiesAndEquityTotals[$currencySymbol] += $value;
    }
}

// Create HTML table to display the balance sheet
echo'<table>
<tr>
  <th>Company Assets</th>
  <th>Currency</th>
  <th align="right">Amount</th>
</tr>';

foreach($assets as $currencySymbol => $values) {
    echo '<tr><td colspan="3"><strong>' . $currencySymbol . '</strong></td></tr>';
    foreach($values as $name => $total) {
        echo '<tr>';
        if($name === 'billsTotal') {
            echo '<td>Bills Payable</td>';
        } else {
            echo '<td>' . ucfirst(str_replace('Total', '', $name)) . '</td>';
        }
        echo '<td>' . $currencySymbol . '</td><td>' . number_format($total, 2) . '</td></tr>';
    }
    echo '<tr class="total"><td>TOTAL ASSETS</td><td>' . $currencySymbol . '</td><td>' . number_format($assetsTotals[$currencySymbol], 2) . '</td></tr>';
}
echo '</table>
<br>
<table>
<tr>
  <th>Liabilities & Equity</th>
  <th>Currency</th>
  <th align="right">Amount</th>
</tr>';

foreach($liabilitiesAndEquity as $currencySymbol => $values) {
    echo '<tr><td colspan="3"><strong>' . $currencySymbol . '</strong></td></tr>';
    foreach($values as $name => $total) {
        echo '<tr><td>' . ucfirst(str_replace('Total', '', $name)) . '</td><td>' . $currencySymbol . '</td><td>' . number_format($total, 2) . '</td></tr>';
    }
    echo '<tr class="total"><td>TOTAL</td><td>' . $currencySymbol . '</td><td>' . number_format($liabilitiesAndEquityTotals[$currencySymbol], 2) . '</td></tr>';
}
echo '</table><br><br>';
