<?php
session_start();
error_reporting(E_ALL);
include("../includes/DbConnect.php");
if (isset($_POST['serialNumber'])) {
  $serialNumber = $_POST['serialNumber'];
  $branchCode = $_SESSION['branchCode'];

  $query = "SELECT itemName, unit_price, cost_price FROM tblpos_stock WHERE serialNumber = :serialNumber AND branchCode = :branchCode";
  $myStatement = $dbConn->prepare($query);
  $myStatement->bindValue(':serialNumber', $serialNumber);
  $myStatement->bindValue(':branchCode', $branchCode);
  $myStatement->execute();

  $results = $myStatement->fetchAll(PDO::FETCH_ASSOC);

  if ($myStatement->rowCount() > 0) {
    foreach ($results as $result) { ?>
      <tr class="item-row">
        <td><input type="checkbox" class="itemRow custom-control-input" name="delete[]" id="${checkboxId}"> <label class="custom-control-label" for="${checkboxId}"></label></td>
        <td><input type="text" class="form-control" name="itemName[]" placeholder="item name" required=""  value="<?php echo htmlentities($result['itemName']);?>"></td>
        <td><input type="text" class="unit_price form-control" name="unit_price[]" placeholder="Price" required="" id="unit_price"  value="<?php echo htmlentities($result['unit_price']);?>">
          <input type="text" class="cost_price form-control" name="cost_price[]" placeholder="Price" required="" id="cost_price"  value="<?php echo htmlentities($result['cost_price']);?>" hidden></td>
        <td><input type="text" class="quantity form-control" name="quantity[]" placeholder="Quantity" required="" id="quantity"></td>
        <td><input type="text" class="amount form-control" name="amount[]" id="amount" readonly=""></td>
      </tr>
    <?php }
  } else {
    echo '';
  }
}